// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "vertexVersionSimple.h"
#include "uniformWorldConstants.h"
#include "uniformPerFrameConstants.h"
#include "uniformShaderConstants.h"

attribute highp vec4 POSITION;

varying highp float lp;

void main()
{
    vec4 hp = POSITION;
    hp.y -= length(hp.xyz) * 0.3;
    gl_Position = WORLDVIEWPROJ * hp;
    lp = length(POSITION.xz);
}
